/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.ai;

import com.lycanitesmobs.core.entity.EntityCreatureBase;
import java.util.Random;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class RandomPositionGenerator {
    private static Vec3d staticVector = new Vec3d(0.0, 0.0, 0.0);

    public static Vec3d findRandomTarget(EntityCreatureBase entity, int range, int height) {
        return RandomPositionGenerator.findRandomTarget(entity, range, height, 0);
    }

    public static Vec3d findRandomTarget(EntityCreatureBase entity, int range, int height, int heightLevel) {
        return RandomPositionGenerator.getTargetBlock(entity, range, height, null, heightLevel);
    }

    public static Vec3d findRandomTargetTowards(EntityCreatureBase entity, int range, int height, Vec3d par3Vec3d) {
        staticVector = new Vec3d(par3Vec3d.field_72450_a - entity.field_70165_t, par3Vec3d.field_72448_b - entity.field_70163_u, par3Vec3d.field_72449_c - entity.field_70161_v);
        return RandomPositionGenerator.findRandomTargetTowards(entity, range, height, staticVector, 0);
    }

    public static Vec3d findRandomTargetTowards(EntityCreatureBase entity, int range, int height, Vec3d par3Vec3d, int heightLevel) {
        staticVector = new Vec3d(par3Vec3d.field_72450_a - entity.field_70165_t, par3Vec3d.field_72448_b - entity.field_70163_u, par3Vec3d.field_72449_c - entity.field_70161_v);
        return RandomPositionGenerator.getTargetBlock(entity, range, height, staticVector, heightLevel);
    }

    public static Vec3d findRandomTargetAwayFrom(EntityCreatureBase entity, int range, int height, Vec3d avoidTarget) {
        return RandomPositionGenerator.findRandomTargetAwayFrom(entity, range, height, avoidTarget, 0);
    }

    public static Vec3d findRandomTargetAwayFrom(EntityCreatureBase entity, int range, int height, Vec3d avoidTarget, int heightLevel) {
        staticVector = new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v).func_178788_d(avoidTarget);
        return RandomPositionGenerator.getTargetBlock(entity, range, height, staticVector, heightLevel);
    }

    private static Vec3d getTargetBlock(EntityCreatureBase entity, int range, int height, Vec3d target, int heightLevel) {
        double homeDistMax;
        double homeDist;
        PathNavigate pathNavigate = entity.func_70661_as();
        Random random = entity.func_70681_au();
        boolean validTarget = false;
        int targetX = 0;
        int targetY = 0;
        int targetZ = 0;
        float pathMin = -99999.0f;
        boolean pastHome = entity.hasHome() ? (homeDist = entity.getHomePosition().func_185332_f(MathHelper.func_76128_c((double)entity.field_70165_t), MathHelper.func_76128_c((double)entity.field_70163_u), MathHelper.func_76128_c((double)entity.field_70161_v)) + 4.0) < (homeDistMax = (double)(entity.getHomeDistanceMax() + (float)range)) * homeDistMax : false;
        for (int attempt = 0; attempt < 10; ++attempt) {
            float pathWeight;
            int possibleX = random.nextInt(2 * range) - range;
            int possibleY = random.nextInt(2 * height) - height;
            int possibleZ = random.nextInt(2 * range) - range;
            if (entity.isFlying() || entity.isStrongSwimmer() && entity.func_70090_H()) {
                if (entity.field_70163_u > (double)entity.field_70170_p.func_175725_q(entity.func_180425_c()).func_177956_o() + (double)heightLevel * 1.25) {
                    possibleY = random.nextInt(2 * height) - height * 3 / 2;
                } else if (entity.field_70163_u < (double)(entity.field_70170_p.func_175725_q(entity.func_180425_c()).func_177956_o() + heightLevel)) {
                    possibleY = random.nextInt(2 * height) - height / 2;
                }
            }
            if (target != null && !((double)possibleX * target.field_72450_a + (double)possibleZ * target.field_72449_c >= 0.0)) continue;
            BlockPos possiblePos = new BlockPos(possibleX += MathHelper.func_76128_c((double)entity.field_70165_t), possibleY += MathHelper.func_76128_c((double)entity.field_70163_u), possibleZ += MathHelper.func_76128_c((double)entity.field_70161_v));
            if (pastHome && !entity.positionNearHome(possibleX, possibleY, possibleZ) || !pathNavigate.func_188555_b(possiblePos) || !((pathWeight = entity.getBlockPathWeight(possibleX, possibleY, possibleZ)) > pathMin)) continue;
            pathMin = pathWeight;
            targetX = possibleX;
            targetY = possibleY;
            targetZ = possibleZ;
            validTarget = true;
        }
        if (validTarget) {
            return new Vec3d((double)targetX, (double)targetY, (double)targetZ);
        }
        return null;
    }
}

